/* ***********************************************************************
   *                                                                     *
   * perfseq.h                                                           *
   * Christian Zurhorst, BID R&D, 30 Jul. 1998                           *
   *                                                                     *
   * performance sequencer functions                                     *
   *                                                                     *
   ***********************************************************************

*/

#ifndef __PERFSEQ_H
#define __PERFSEQ_H

#include <perfdefs.h>


#ifdef __cplusplus
extern "C" {
#endif


CLI b_errtype EXPORT BestPerfSeqPropDefaultSet(  /* @psprpdefset */
    b_handletype handle,
    b_int32      measure                         /* @meas        */
    );

CLI b_errtype EXPORT BestPerfGenPropSet(         /* @pgenprpset  */
    b_handletype handle,
    b_int32 measure,                             /* @meas        */
    b_perfgenproptype perfgenprop,               /* @prop        */
    b_int32 value                                /* @val         */
    );

CLI b_errtype EXPORT BestPerfGenPropGet(         /* @pgenprpget  */
    b_handletype handle,
    b_int32 measure,                             /* @meas        */
    b_perfgenproptype perfgenprop,               /* @prop        */
    b_int32 *value                               /*  #RETURN  "property value = %d\n"*/
    );

CLI b_errtype EXPORT BestPerfGenPropDefaultSet(  /* @pgenprpdefset  */
    b_handletype handle,
    b_int32 measure                              /* @meas */
    );

CLI b_errtype EXPORT BestPerfSeqTranPropSet(     /* @pstranprpset    */
    b_handletype handle,
    b_int32 measure,                             /* @meas        */
    b_int32 transient,                           /* @tran        */
    b_perfseqtranproptype perfseqtranprop,       /* @prop        */
    b_int32 value                                /* @val         */
    );

CLI b_errtype EXPORT BestPerfSeqTranPropGet(     /* @pstranprpget    */
    b_handletype handle,
    b_int32 measure,                             /* @meas        */
    b_int32 transient,                           /* @tran        */
    b_perfseqtranproptype perfseqtranprop,       /* @prop        */
    b_int32 *value                               /*  #RETURN  "property value = %d\n"*/
    );

CLI b_errtype EXPORT BestPerfSeqTranPropDefaultSet( /* @pstranprpdefset */
    b_handletype handle,
    b_int32 measure,                             /* @meas        */
    b_int32 transient                            /* @tran        */
    );

CLI b_errtype EXPORT BestPerfSeqTranCondPropSet( /* @pstrancprpset   */
    b_handletype handle,
    b_int32 measure,                             /* @meas        */
    b_int32 transient,                           /* @tran        */
    b_perfseqtrancondproptype perfseqtrancondprop, /* @prop        */
    b_charptrtype condition                      /* @con         */
    );

CLI b_errtype EXPORT BestPerfSeqTranCondPropGet( /* @pstrancprpget   */
    b_handletype handle,
    b_int32 measure,                             /* @meas        */
    b_int32 transient,                           /* @tran        */
    b_perfseqtrancondproptype perfseqtrancondprop, /* @prop        */
    b_int32 *value                               /*  #RETURN  "property value (parsed) = %08lx\\h\n"*/
    );

CLI b_errtype EXPORT BestPerfSeqProg(            /* @psprog   */
    b_handletype handle,
    b_int32 measure                              /* @meas     */
    );

CLI b_errtype EXPORT BestPerfRun(                /* @prun   */
    b_handletype handle
    );

CLI b_errtype EXPORT BestPerfStop(               /* @pstop   */
    b_handletype handle
    );

CLI b_errtype EXPORT BestPerfStatusGet(       /* @psget   */
    b_handletype handle,
    b_int32 measure,                             /* @meas    */
    b_int32 *value                               /*  #RETURN  "%08lx\\h"*/
    );


CLI b_errtype EXPORT BestPerfUpdate(             /* @pupdate   */
    b_handletype handle
    );

CLI b_errtype EXPORT BestPerfCtrRead(            /* @pctrread   */
    b_handletype handle,
    b_int32 measure,                             /* @meas */
    b_int32 counter_id,                          /* @cid */
    b_int32 *value                               /* #RETURN  "%08lx\\h\n"*/
    );

CLI b_errtype EXPORT BestAboutPerfBoardGet(      /* @aboutperf   */
    b_handletype handle,
    b_int32 *info                                /* #RETURN "%d Robert Siegmund, HP Germany.\n" */
    );

b_int32 EXPORT perfboard_mode_get();


#ifdef __cplusplus
}
#endif


#endif


